
<?php require_once("admin/includes/header_public.php"); ?>


<body class="campus-facilities-page">

  
  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="heading">
        <div class="container">
          <div class="row d-flex justify-content-center text-center">
            <div class="col-lg-8">
              <h1 class="heading-title">Campus &amp; Facilities</h1>
              <p class="mb-0">Esse dolorum voluptatum ullam est sint nemo et est ipsa porro placeat quibusdam quia assumenda numquam molestias.</p>
            </div>
          </div>
        </div>
      </div>
      <nav class="breadcrumbs">
        <div class="container">
          <ol>
            <li><a href="index.html">Home</a></li>
            <li class="current">Campus Facilities</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Page Title -->

    <!-- Campus Facilities Section -->
    <section id="campus-facilities" class="campus-facilities section">

      <div class="container">

        <!-- Campus Overview -->
        <div class="campus-overview">
          <div class="row align-items-center">
            <div class="col-lg-6">
              <div class="overview-content">
                <h1>Inspiring Spaces for Learning</h1>
                <p class="lead-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p>

                <div class="campus-stats">
                  <div class="stat-item">
                    <span class="stat-number">150</span>
                    <span class="stat-label">Acres</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-number">42</span>
                    <span class="stat-label">Buildings</span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-number">18k</span>
                    <span class="stat-label">Students</span>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="overview-image">
                <img src="assets/img/education/campus-3.webp" alt="Campus Overview" class="img-fluid">
              </div>
            </div>
          </div>
        </div>

        <!-- Facility Categories -->
        <div class="facility-categories">
          <div class="categories-header">
            <h2>World-Class Facilities</h2>
            <p>Suspendisse potenti. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.</p>
          </div>

          <div class="categories-grid">
            <div class="facility-card academic-spaces">
              <div class="card-image">
                <img src="assets/img/education/campus-4.webp" alt="Academic Spaces" class="img-fluid">
              </div>
              <div class="card-content">
                <div class="category-icon">
                  <i class="bi bi-mortarboard"></i>
                </div>
                <h3>Academic Excellence</h3>
                <ul class="facility-features">
                  <li>State-of-the-art lecture halls</li>
                  <li>Interactive learning labs</li>
                  <li>Collaborative study spaces</li>
                  <li>Research facilities</li>
                </ul>
                <a href="#" class="facility-link">Explore Academic Spaces</a>
              </div>
            </div>

            <div class="facility-card sports-wellness">
              <div class="card-image">
                <img src="assets/img/education/campus-5.webp" alt="Sports &amp; Wellness" class="img-fluid">
              </div>
              <div class="card-content">
                <div class="category-icon">
                  <i class="bi bi-heart"></i>
                </div>
                <h3>Sports &amp; Wellness</h3>
                <ul class="facility-features">
                  <li>Olympic-size swimming pool</li>
                  <li>Multi-purpose gymnasium</li>
                  <li>Wellness center</li>
                  <li>Outdoor sports courts</li>
                </ul>
                <a href="#" class="facility-link">Explore Wellness Facilities</a>
              </div>
            </div>

            <div class="facility-card student-life">
              <div class="card-image">
                <img src="assets/img/education/campus-1.webp" alt="Student Life" class="img-fluid">
              </div>
              <div class="card-content">
                <div class="category-icon">
                  <i class="bi bi-people"></i>
                </div>
                <h3>Student Life</h3>
                <ul class="facility-features">
                  <li>Modern dormitories</li>
                  <li>Student union building</li>
                  <li>Dining commons</li>
                  <li>Recreation centers</li>
                </ul>
                <a href="#" class="facility-link">Explore Student Life</a>
              </div>
            </div>
          </div>
        </div>

        <!-- Virtual Tour Section -->
        <div class="virtual-tour-section">
          <div class="tour-container">
            <div class="row align-items-center">
              <div class="col-lg-7">
                <div class="tour-visual">
                  <div class="video-wrapper">
                    <video autoplay="" muted="" loop="">
                      <source src="assets/img/education/video-3.mp4" type="video/mp4">
                    </video>
                    <div class="tour-overlay">
                      <div class="tour-badge">
                        <i class="bi bi-camera-video"></i>
                        <span>360° Virtual Tour</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-5">
                <div class="tour-content">
                  <h2>Experience Our Campus</h2>
                  <p>Nulla facilisi morbi tempus iaculis urna id volutpat lacus laoreet non curabitur gravida arcu ac tortor dignissim convallis.</p>

                  <div class="tour-features">
                    <div class="feature-item">
                      <i class="bi bi-play-circle"></i>
                      <span>Interactive walkthrough</span>
                    </div>
                    <div class="feature-item">
                      <i class="bi bi-map"></i>
                      <span>Campus navigation</span>
                    </div>
                    <div class="feature-item">
                      <i class="bi bi-info-circle"></i>
                      <span>Detailed facility information</span>
                    </div>
                  </div>

                  <div class="tour-actions">
                    <a href="#" class="btn-tour">Start Virtual Tour</a>
                    <a href="#" class="btn-schedule">Schedule Visit</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Campus Gallery -->
        <div class="campus-gallery">
          <div class="gallery-header">
            <h2>Campus Life in Pictures</h2>
            <p>Mauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Vestibulum ac diam sit amet quam vehicula elementum.</p>
          </div>

          <div class="gallery-showcase swiper init-swiper">
            <script type="application/json" class="swiper-config">
              {
                "loop": true,
                "speed": 600,
                "autoplay": {
                  "delay": 4000
                },
                "slidesPerView": 1,
                "spaceBetween": 0,
                "centeredSlides": true,
                "navigation": {
                  "nextEl": ".gallery-next",
                  "prevEl": ".gallery-prev"
                },
                "pagination": {
                  "el": ".swiper-pagination",
                  "clickable": true
                },
                "breakpoints": {
                  "768": {
                    "slidesPerView": 1.5
                  },
                  "1024": {
                    "slidesPerView": 2.5
                  }
                }
              }
            </script>
            <div class="swiper-wrapper">
              <div class="swiper-slide">
                <div class="gallery-item">
                  <img src="assets/img/education/facilities-1.webp" alt="Library" class="img-fluid" loading="lazy">
                  <div class="item-overlay">
                    <div class="overlay-content">
                      <h4>Central Library</h4>
                      <p>A quiet haven for research and study with over 2 million volumes</p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="gallery-item">
                  <img src="assets/img/education/facilities-2.webp" alt="Science Lab" class="img-fluid" loading="lazy">
                  <div class="item-overlay">
                    <div class="overlay-content">
                      <h4>Science Laboratory</h4>
                      <p>Cutting-edge equipment for innovative research and discovery</p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="gallery-item">
                  <img src="assets/img/education/facilities-3.webp" alt="Student Union" class="img-fluid" loading="lazy">
                  <div class="item-overlay">
                    <div class="overlay-content">
                      <h4>Student Union</h4>
                      <p>The heart of campus social life and student activities</p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="gallery-item">
                  <img src="assets/img/education/facilities-4.webp" alt="Recreation Center" class="img-fluid" loading="lazy">
                  <div class="item-overlay">
                    <div class="overlay-content">
                      <h4>Recreation Center</h4>
                      <p>Modern fitness facilities and wellness programs</p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="swiper-slide">
                <div class="gallery-item">
                  <img src="assets/img/education/facilities-5.webp" alt="Arts Building" class="img-fluid" loading="lazy">
                  <div class="item-overlay">
                    <div class="overlay-content">
                      <h4>Arts Building</h4>
                      <p>Creative spaces for artistic expression and performance</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="swiper-pagination"></div>
            <div class="swiper-button-prev gallery-prev"></div>
            <div class="swiper-button-next gallery-next"></div>
          </div>
        </div>

        <!-- Campus Map -->
        <div class="campus-map-section">
          <div class="map-header">
            <h2>Navigate Our Campus</h2>
            <p>Pellentesque in ipsum id orci porta dapibus. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus.</p>
          </div>

          <div class="map-container">
            <div class="row">
              <div class="col-lg-8">
                <div class="map-embed">
                  <div class="ratio ratio-16x9">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3025.3063876156327!2d-74.04668908459373!3d40.68924307933441!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c25a22a3bda30d%3A0xb89d1fe6bc499443!2sDowntown%20Brooklyn!5e0!3m2!1sen!2sus!4v1234567890123!5m2!1sen!2sus" allowfullscreen="" loading="lazy"></iframe>
                  </div>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="map-sidebar">
                  <div class="map-info">
                    <h4>Campus Address</h4>
                    <p>1847 University Drive<br>Brooklyn, NY 11205</p>
                  </div>

                  <div class="map-services">
                    <div class="service-item">
                      <i class="bi bi-geo-alt"></i>
                      <div class="service-content">
                        <strong>Campus Tours</strong>
                        <span>Daily at 10 AM &amp; 2 PM</span>
                      </div>
                    </div>
                    <div class="service-item">
                      <i class="bi bi-bus-front"></i>
                      <div class="service-content">
                        <strong>Shuttle Service</strong>
                        <span>Free campus transportation</span>
                      </div>
                    </div>
                    <div class="service-item">
                      <i class="bi bi-p-square"></i>
                      <div class="service-content">
                        <strong>Parking</strong>
                        <span>Multiple lots available</span>
                      </div>
                    </div>
                  </div>

                  <div class="map-actions">
                    <a href="#" class="map-link">
                      <i class="bi bi-download"></i>
                      Download Campus Map
                    </a>
                    <a href="#" class="map-link">
                      <i class="bi bi-directions"></i>
                      Get Directions
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </section><!-- /Campus Facilities Section -->

  </main>
  
<?php require_once("admin/includes/footer_public.php"); ?>